/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.datagen;

import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.loot.ParagliderModifier;
import tictim.paraglider.loot.SpiritOrbLootModifier;
import tictim.paraglider.loot.VesselLootModifier;

public class LootModifierProvider
extends GlobalLootModifierProvider {
    public LootModifierProvider(DataGenerator gen, String modid) {
        super(gen, modid);
    }

    protected void start() {
        this.add("towers_of_the_wild/chest", (GlobalLootModifierSerializer)Contents.PARAGLIDER_MODIFIER.get(), (IGlobalLootModifier)new ParagliderModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("towers_of_the_wild", "chests/tower/regular/tower_chest")).m_6409_()}));
        this.add("towers_of_the_wild/ocean_chest", (GlobalLootModifierSerializer)Contents.PARAGLIDER_MODIFIER.get(), (IGlobalLootModifier)new ParagliderModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("towers_of_the_wild", "chests/tower/ocean/ocean_tower_chest")).m_6409_()}, true));
        this.add("wither", (GlobalLootModifierSerializer)Contents.VESSEL_MODIFIER.get(), (IGlobalLootModifier)new VesselLootModifier(new LootItemCondition[]{LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20496_)).m_6409_(), LootItemKilledByPlayerCondition.m_81901_().m_6409_()}, 1));
        this.addSpiritOrbItemModifier("spawner", new SpiritOrbLootModifier(new LootItemCondition[]{LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50085_).m_6409_()}, 2));
        this.addChestSpiritOrbItemModifier("underwater_ruin_big", 0.5f);
        this.addChestSpiritOrbItemModifier("underwater_ruin_small", 0.5f);
        this.addChestSpiritOrbItemModifier("jungle_temple");
        this.addChestSpiritOrbItemModifier("desert_pyramid", 0.5f);
        this.addChestSpiritOrbItemModifier("bastion_other");
        this.addChestSpiritOrbItemModifier("bastion_bridge");
        this.addChestSpiritOrbItemModifier("bastion_treasure");
        this.addChestSpiritOrbItemModifier("bastion_hoglin_stable");
        this.addChestSpiritOrbItemModifier("stronghold_corridor", 0.5f);
        this.addChestSpiritOrbItemModifier("stronghold_crossing", 0.5f);
        this.addChestSpiritOrbItemModifier("stronghold_library");
        this.addChestSpiritOrbItemModifier("nether_bridge", 0.5f);
        this.addChestSpiritOrbItemModifier("buried_treasure");
    }

    private void addChestSpiritOrbItemModifier(String chestLootTableName, float chance) {
        this.addSpiritOrbItemModifier(chestLootTableName, new SpiritOrbLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("chests/" + chestLootTableName)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)chance).m_6409_()}, 1));
    }

    private void addChestSpiritOrbItemModifier(String chestLootTableName) {
        this.addSpiritOrbItemModifier(chestLootTableName, new SpiritOrbLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation("chests/" + chestLootTableName)).m_6409_()}, 1));
    }

    private void addSpiritOrbItemModifier(String modifier, SpiritOrbLootModifier instance) {
        this.add("spirit_orbs/" + modifier, (GlobalLootModifierSerializer)Contents.SPIRIT_ORB_MODIFIER.get(), (IGlobalLootModifier)instance);
    }
}

